/*****************************************************************************
 * NAME         : td_mp4.h
 * FUNCTION     : MP4  תط
 * PROGRAMMED   : ʤ
 * DATE         : 2014-12-10
 * PROJECT      : 
 * OS           : Linux
 ****************************************************************************/  

#ifndef __TD_MP4_H_INCLUDED__
#define __TD_MP4_H_INCLUDED__

//==============================20151229 mp4 decode start================================================

typedef unsigned char		td_u8;
typedef unsigned char       td_uchar;
typedef unsigned short		td_u16;
typedef unsigned int		td_u32;
typedef unsigned long long 	td_u64;
typedef signed char			td_s8;
typedef short				td_s16;
typedef int					td_s32;
typedef long long			td_s64;


typedef char                td_char;
typedef float				td_float;
typedef double				td_double;
typedef void                td_void;
typedef long double			td_ldouble;

typedef enum {
	td_false    = 0,
	td_true     = 1,
} td_bool;


typedef void       td_MP4FileHandle;

typedef enum{
	SEEK_FORWARD,
	SEEK_BACKWARD,
	SEEK_ABSOLUTE,		
}ESeekOps;


typedef enum{
	SIGN_SAMPLEID_KEY = 1 << 0,/*ǻ*/
	SIGN_SAMPLEID_LIFE = 1 << 3,/**/		
}ESignInfo;

typedef struct
{
	unsigned short  FrameRate;	//֡
	unsigned short  Width;		//ͼ
	unsigned short  Height;		//ͼ
	unsigned short  Mode;		//ģʽ11MP4) 21(H264)
	unsigned short  bAudio;		//ǷƵ
	unsigned short  Year;		//H264벻ֶΣȫ0xFF,ԲΪ¼ʱ
	unsigned short  Month;
	unsigned short  Day;
	unsigned short  Hour;
	unsigned short  Minute;
	unsigned short  Second;
	unsigned short  CoverMask;
	char cCovWord[36];		//̶ַ"S MULTI-MEDIA STREAM (H.264)"0x00ʣಿ0xFF
	unsigned int 	m_uiFrameNoDiff;	// ļβ֡Ų
	unsigned int 	TriggerHigh;	// ¼˿ں20120906 
	unsigned int 	TriggerLow;	// ¼˿ں20120906 
	unsigned short	reserved;		//cCovWordǰĳȣǰֵΪ36
	unsigned char   AChannels;   // 1/2ĬΪ1
	unsigned char   BitsPerSample;// λ8/16/24, Ĭ16
	unsigned int 	AudioSample;
	unsigned int    TotalSize;	//ļܴС(ֽ)ϰ汾
	unsigned int    FrameCount;	//ļ֡,ϰ汾
}S_FileHeader,*pS_FileHeader;

td_bool MP4_IsMP4Format(td_char* _pcFileName);
//td_s32 MP4_GetLogicSdvInfo(td_char *_pcFileName, TSdvTimeSumInfo *_pstTSdvTimeSumInfo);//MP4_GetSdvConvertInfo
td_MP4FileHandle *MP4_Open (td_char *_pcFileName);
td_s32 MP4_Close (td_MP4FileHandle *_pMP4fh);
td_s32 MP4_GetFileHead(td_MP4FileHandle *_pMP4fh, S_FileHeader *_pstMP4FileHead);
td_s32 MP4_GetEncryptStat(td_MP4FileHandle *_pMP4fh, int* _piEncryptStat);
td_s32 MP4_GetSignInfo(td_MP4FileHandle *_pMP4fh, ESignInfo _type, td_void **_pSignData, td_u32 *_dataLen);
td_void MP4_Free(td_void *_pAddr);
td_s32 MP4_Read (td_MP4FileHandle *_pMP4fh, td_void *_pFrameBuf, td_u32 _bufLen);
td_s32 MP4_Seek(td_MP4FileHandle *_pMP4fh, td_u64 _frameId, ESeekOps _type);
td_s32 MP4_CopyMP4FileNoAudio(char* _pcSrcFileName, char* _pcDstFileName);

//==============================20151229 mp4 decode end================================================

#endif //__TD_MP4_H_INCLUDED__

